library(spatialreg)
data(oldcol, package="spdep")
lwB <- spdep::nb2listw(COL.nb, style="B")
mod0 <- lmSLX(CRIME ~ INC + HOVAL, data=COL.OLD, listw=lwB)
coef(mod0)
INCB <- spdep::lag.listw(lwB, COL.OLD$INC)
HOVALB <- spdep::lag.listw(lwB, COL.OLD$HOVAL)
INTERCEPTB <- spdep::card(lwB$neighbours)
mod1 <- lm(CRIME ~ INC + HOVAL + INTERCEPTB + INCB + HOVALB, data=COL.OLD)
expect_true(isTRUE(all.equal(unname(coef(mod0)), unname(coef(mod1)))))
expect_warning(modx <- lmSLX(CRIME ~ INC + HOVAL + 0, data=COL.OLD, listw=lwB))
mod1x <- lm(CRIME ~ INC + HOVAL + 0 + INCB + HOVALB, data=COL.OLD)
expect_true(isTRUE(all.equal(unname(coef(modx)), unname(coef(mod1x)))))

