% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripleys_k.R
\name{ripleys_k}
\alias{ripleys_k}
\title{Calculate Univariate Ripley's K function for IF data}
\usage{
ripleys_k(
  mif,
  id,
  mnames,
  r_range = seq(0, 100, 50),
  num_permutations = 50,
  edge_correction = "translation",
  kestimation = TRUE,
  keep_perm_dis = FALSE,
  mlabels = NULL
)
}
\arguments{
\item{mif}{An MIF object}

\item{id}{Character string of variable name for subject ID in TMA data.}

\item{mnames}{Character vector of marker names to calculate Ripley's K on.}

\item{r_range}{Numeric vector of potential r values to estimate K at.}

\item{num_permutations}{Numeric value indicating the number of permutations used.
Default is 50.}

\item{edge_correction}{Character value indicating the type of edge correction
to use. Options include "translation", "isotropic" or "border".
Various edges corrections are most appropriate in different settings. Default
is "translation".}

\item{kestimation}{Logical value determining the type estimation performed.
TRUE estimates Ripley's reduced second moment function while FALSE
estimates Besags's transformation of Ripley's K.}

\item{keep_perm_dis}{Logical value determining whether or not to keep the full
distribution of permuted K values}

\item{mlabels}{Character vector of label for marker names to display in the marker column.}
}
\value{
Returns a list
\item{r}{Subject ID in TMA data}
\item{theo}{Ripley's K estimate}
}
\description{
This function calculates Ripley's K function of IF data to
characterize correlation of spatial point process using tranlation and
isotropic edge correction method.
}
