% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hli.pt.R
\name{hli.pt}
\alias{hli.pt}
\title{Point estimate of Heat Load Index}
\usage{
hli.pt(
  alpha,
  theta,
  latitude,
  direct = FALSE,
  scaled = TRUE,
  force.hemisphere = c("none", "southern", "northern")
)
}
\arguments{
\item{alpha}{Aspect in degrees}

\item{theta}{Slope in degrees}

\item{latitude}{A latitude representing the centrality of the data}

\item{direct}{Boolean (FALSE/TRUE) Return direct incident radiation 
else HLI (default)}

\item{scaled}{Boolean (TRUE/FALSE) Apply arithmetic scale using EXP(h)}

\item{force.hemisphere}{If country is split at the equator, force southern 
or northern hemisphere equation c("southern", "northern")}
}
\value{
Vector of McCune & Keon (2002) Heat Load Index
}
\description{
Calculates the McCune & Keon (2002) Heat Load Index
}
\note{
Describes A southwest facing slope should have warmer temperatures than a 
southeast facing slope, even though the amount of solar radiation they receive 
is equivalent. The McCune and Keon (2002) method accounts for this by "folding" 
the aspect so that the highest values are southwest and the lowest values are  
northeast. Additionally, this method account for steepness of slope, which is 
not addressed in most other aspect rescaling equations. HLI values range 
from 0 (coolest) to 1 (hottest).

The equations follow McCune (2007) and support northern and southern hemisphere 
calculations. The folded aspect for northern hemispheres use (180 - (Aspect – 225) ) 
and for Southern hemisphere  ( 180 - ( Aspect – 315) ). If a country is split at the 
equator you can use the force.hemisphere argument to choose which equation to use. 
Valid values for this argument are "southern" and "northern" with the default "none".
}
\examples{

# Single input
hli.pt(theta=180, alpha=30, latitude=40) 

# Multiple input, returns results from 
#   McCune, B., and D. Keon (2002)
# Raw -0.2551 -0.6280 0.0538 -0.6760 -1.1401 -0.2215
# arithmetic scale 0.7748 0.5337 1.0553 0.5086 0.3198 0.8013

slp = c(0, 30, 30, 0, 30, 30)
asp =c(0, 0, 180, 0, 0, 180)
lat =c(40, 40, 40, 60, 60, 60)
hli.pt(theta = slp, alpha = asp, latitude = lat)
  
}
\references{
McCune, B., and D. Keon (2002) Equations for potential annual direct 
  incident radiation and heat load index. Journal of Vegetation 
  Science. 13:603-606.

McCune, B. (2007). Improved estimates of incident radiation and heat load 
  using non-parametric regression against topographic variables. Journal 
  of Vegetation Science 18:751-754.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
