% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlogram.R
\name{correlogram}
\alias{correlogram}
\title{Correlogram}
\usage{
correlogram(x, v, dist = 5000, ns = 99, ...)
}
\arguments{
\item{x}{A sf POINT object}

\item{v}{Test variable in x}

\item{dist}{Distance of correlation lags, if latlong=TRUE units are
great circle in kilometers}

\item{ns}{Number of simulations to derive simulation envelope}

\item{...}{Arguments passed to cor ('pearson', 'kendall' or 'spearman')}
}
\value{
A list object containing:
\itemize{
\item autocorrelation is a data.frame object with the following components
\item autocorrelation - Autocorrelation value for each distance lag
\item dist - Value of distance lag
\item lci - Lower confidence interval (p=0.025)
\item uci - Upper confidence interval (p=0.975)
\item CorrPlot recordedplot object to recall plot
}
}
\description{
Calculates and plots a correlogram
}
\examples{
library(sf)
if(require(sp, quietly = TRUE)) {
  data(meuse, package = "sp")
  meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                    agr = "constant")
}

zinc.cg <- correlogram(x = meuse, v = meuse$zinc, dist = 250, ns = 9)

}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
