% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.holes.R
\name{remove.holes}
\alias{remove.holes}
\title{Remove polygon holes}
\usage{
remove.holes(x)
}
\arguments{
\item{x}{SpatialPolygons or SpatialPolygonsDataFrame class object}
}
\value{
SpatialPolygonsDataFrame object with all holes removed
}
\description{
Removes all holes (null geometry) in polygon sp class objects
}
\note{
A hole is considered a polygon within a polygon representing null geometry
}
\examples{
 library(sp)
 Sr1 = Polygon(cbind(c(2,4,4,1,2),c(2,3,5,4,2)))
 Sr2 = Polygon(cbind(c(5,4,2,5),c(2,3,2,2)))
 Sr3 = Polygon(cbind(c(4,4,5,10,4),c(5,3,2,5,5)))
 Sr4 = Polygon(cbind(c(5,6,6,5,5),c(4,4,3,3,4)), hole = TRUE)
 polys <- SpatialPolygons(list(Polygons(list(Sr1), "s1"),
                 Polygons(list(Sr2), "s2"),
                 Polygons(list(Sr3, Sr4), "s3/4")), 1:3)

opar <- par(no.readonly=TRUE)
   par(mfrow=c(1,2))
     plot(polys, col = 1:3, main="with hole")
     plot(remove.holes(polys), col = 1:3, main="with hole removed")
par(opar)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
