% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.tab.R
\name{cross.tab}
\alias{cross.tab}
\title{Class comparison between two nominal rasters}
\usage{
cross.tab(x, y, values = NULL, labs = NULL, pct = FALSE, ...)
}
\arguments{
\item{x}{rasterLayer class object}

\item{y}{rasterLayer class object to compare to x}

\item{values}{Expected values in both rasters}

\item{labs}{Labels associated with values argument}

\item{pct}{(TRUE/FALSE) return proportions rather than counts}

\item{...}{Additional arguments}
}
\value{
a table with the cross tabulated counts
}
\description{
Creates a labeled cross tabulation between two nominal rasters
}
\note{
This function returns a cross tabulation between two nominal rasters. 
Arguments allow for labeling the results and returning proportions 
rather than counts. It also accounts for asymmetrical classes between
the two rasters
}
\examples{
 library(sp)
 library(raster)
   data(meuse.grid)
 
 r1 <- sp::SpatialPixelsDataFrame(points = meuse.grid[c("x", "y")], 
                                  data = meuse.grid)
 lulc2010 <- raster(r1)
   na.idx <- which(!is.na(lulc2010[]))
     lulc2010[na.idx] <- sample(1:5, length(na.idx), replace=TRUE)
  
 lulc2020 <- raster(lulc2010)
   lulc2020[na.idx] <- sample(1:5, length(na.idx), replace=TRUE)
 
 ( v = sort(unique(c(lulc2010[], lulc2020[]))) )
 l = c("water","urban","forest",
       "ag","barren")

 cross.tab(lulc2010, lulc2020) 
 cross.tab(lulc2010, lulc2020, values = v, labs = l)
 cross.tab(lulc2010, lulc2020, values = v, labs = l, pct=TRUE)

# Create asymmetrical classes 
lulc2020[na.idx] <- sample(c(1,2,4,5), length(na.idx), replace=TRUE)

cross.tab(lulc2010, lulc2020, values = v, labs = l, pct=TRUE)

}
\references{
Pontius Jr, R.G., Shusas, E., McEachern, M. (2004). Detecting
important categorical land changes while accounting for persistence.
Agriculture, Ecosystems & Environment 101(2):251-268.
}
\seealso{
\code{raster::\link[raster]{crosstab}}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
