% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.pdf.R
\name{group.pdf}
\alias{group.pdf}
\title{Probability density plot by group}
\usage{
group.pdf(
  x,
  y,
  col = NULL,
  lty = NULL,
  lwd = NULL,
  lx = "topleft",
  ly = NULL,
  ...
)
}
\arguments{
\item{x}{Numeric, character or factorial vector of grouping variable (must be same length as y)}

\item{y}{Numeric vector (density variable)}

\item{col}{Optional line colors (see par, col)}

\item{lty}{Optional line types (see par, lty)}

\item{lwd}{Optional line widths (see par, lwd)}

\item{lx}{Position of legend (x coordinate or 'topright', 'topleft', 'bottomright', 'bottomleft')}

\item{ly}{Position of legend (y coordinate)}

\item{...}{Additional arguments passed to plot}
}
\description{
Creates a probability density plot of y for each group of x
}
\examples{
y=dnorm(runif(100))
x=rep(c(1,2,3), length.out=length(y)) 
group.pdf(x=as.factor(x), y=y, main='Probability Density of y by group(x)', 
ylab='PDF', xlab='Y', lty=c(1,2,3))

}
\references{
Simonoff, J. S. (1996). Smoothing Methods in Statistics. Springer-Verlag, New York.
}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}
