% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idw.smoothing.R
\name{idw.smoothing}
\alias{idw.smoothing}
\title{idw.smoothing}
\usage{
idw.smoothing(x, y, d, k)
}
\arguments{
\item{x}{Object of class SpatialPointsDataFrame}

\item{y}{Numeric data in x@data}

\item{d}{Distance constraint}

\item{k}{Maximum number of k-nearest neighbours within d}
}
\value{
A vector, same length as nrow(x), of adjusted y values
}
\description{
Distance weighted smoothing of a variable in a spatial point object
}
\note{
Smoothing is conducted with a weighted-mean where; weights represent inverse standardized distance lags
Distance-based or neighbour-based smoothing can be specified by setting the desired neighbour smoothing method to a specified value then the other parameter to the potential maximum. 
For example; a constraint distance, including all neighbours within 1000 (d=1000) would require k to equal all of the potential neighbours (n-1 or k=nrow(x)-1).

Depends: sp, RANN
}
\examples{
 library(sp)
  data(meuse)                                                   
  coordinates(meuse) <- ~x+y             

# Calculate distance weighted mean on cadmium variable in meuse data   
  cadmium.idw <- idw.smoothing(meuse, 'cadmium', k=nrow(meuse), d = 1000)                
  meuse@data$cadmium.wm <- cadmium.idw
  opar <- par 
  par(mfrow=c(2,1)) 
  plot(density(meuse@data$cadmium), main='Cadmium')
  plot(density(meuse@data$cadmium.wm), main='IDW Cadmium')
  par <- opar

}

