% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_extent.R
\name{fix_extent}
\alias{fix_extent}
\title{Forces a list of Raster*s to all have the same extent.}
\usage{
fix_extent(extent_reference, broken_extents)
}
\arguments{
\item{extent_reference}{Raster*. A Raster* object that will provide the extent to all the other Raster*s.  If unassigned, will assume it is the first Raster* in the broken_extents list.}

\item{broken_extents}{list of Raster* objects. Raster* objects that will be coerced to the extent_reference's extent.}
}
\description{
Forces a list of Raster*s to all have the same extent.
}
\examples{
library("raster")
tahoe_highrez <- brick(system.file("external/tahoe_highrez.tif", package="spatial.tools"))
tahoe_highrez
tahoe_highrez_broken <- tahoe_highrez
# We'll "break" the extent:
extent(tahoe_highrez_broken) <- c(0,360,-90,90)
tahoe_highrez_broken
tahoe_highrez_fixed <- fix_extent(tahoe_highrez,tahoe_highrez_broken)
tahoe_highrez_fixed

}
\seealso{
\code{\link{extent}},\code{\link{stack}}
}
\author{
Jonathan A. Greenberg (\email{spatial.tools@estarcion.net})
}
