% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFunctions.R
\name{spathialLabels}
\alias{spathialLabels}
\title{Find labels}
\usage{
spathialLabels(X, X_labels, spathial_res)
}
\arguments{
\item{X}{data points}

\item{X_labels}{labels of the data points}

\item{spathial_res}{principal path from the starting point to the ending point}
}
\value{
ppath_labels: labels of the waypoints
}
\description{
Get the label of each waypoint according to the neighbourhood
}
\examples{
#EXAMPLE 1
# Load data matrix X
load(system.file('extdata','X.rda',package='spathial',mustWork=TRUE))
# Load description vector X_labels
load(system.file('extdata','X_labels.rda',package='spathial',mustWork=TRUE))
# Run spathialBoundary
boundaryRes <- spathialBoundaryIds(X, X_labels, mode=2, from=3, to=6)
X <- boundaryRes$X
X_labels <- boundaryRes$X_labels
boundary_ids <- boundaryRes$boundary_ids
#Set the number of waypoints
NC <- 20
# Run spathialWay
spathial_res <- spathialWay(X, boundary_ids, NC)
#Run spathialLabels with spathial_res
labels <- spathialLabels(X, X_labels, spathial_res)
labels
}
