% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curves.R
\name{plot_curve}
\alias{plot_curve}
\title{plot \code{spatgeom} objects}
\usage{
plot_curve(x, type = c("curve", "deriv"), font_size = 12)
}
\arguments{
\item{x}{an object of class \code{spatgeom}}

\item{type}{a string that could be \code{curve} or \code{deriv}. The option
\code{curve} plots the curve of \code{alpha} against \code{geom_corr} from
the function \code{\link[=alphastats]{alphastats()}}. The \code{deriv} option plots the
numerical derivative.}

\item{font_size}{a integer that increases the font size in the plot.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object with the geometric indices (or
its derivative). The plot is generated with the \code{nalphas} point of
\code{alpha} and \code{geom_corr} from the function
\code{\link{alphastats}}.

In each panel, the theoretical CSR process is drawn using
\code{exp(-intensity * pi * x^2)}. where the intensity depends on each
panel.
}
\description{
Plot method for objects of class \code{spatgeom}.
}
\examples{
n <- 30
a <- -1
b <- 1
theta <- runif(n, 0, 2 * pi)
r <- (sqrt(runif(n))) * (0.5) + 0.5
X1 <- r * cos(theta)
X2 <- runif(n, a, b)
Y <- data.frame(Y = r * sin(theta))
X <- data.frame(X1, X2)

estimation <- alphastats(y = Y, x = X)

plot_curve(estimation, type = "curve")

plot_curve(estimation, type = "deriv")
}
