% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_rmeasure.R
\name{vec_rmeasure}
\alias{vec_rmeasure}
\alias{vec_rmeasure-spatPomp}
\alias{vec_rmeasure,spatPomp-method}
\title{Vector simulating measurements for each unit using \code{runit_measure}}
\usage{
\S4method{vec_rmeasure}{spatPomp}(object, x, times, params, ...)
}
\arguments{
\item{object}{a \code{spatPomp} object}

\item{x}{numeric; state at which measurements are simulated}

\item{times}{numeric; time at which measurements are simulated}

\item{params}{numeric; parameter set at which measurements are simulated}

\item{\dots}{additional parameters will be ignored}
}
\value{
An array of dimension \code{length(unit_names(object))} by \code{dim(x)[2]} by \code{dim(x)[3]}
representing each unit's simulated measurement assessed for each replicate in \code{x} for each observation time.
}
\description{
Simulate from the unit measurement model density function for each unit
}
\author{
Kidus Asfaw
}
