% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measles.R
\name{measles}
\alias{measles}
\title{Measles in UK spatPomp generator}
\usage{
measles(
  U = 6,
  dt = 2/365,
  fixed_ivps = TRUE,
  S_0 = 0.032,
  E_0 = 5e-05,
  I_0 = 4e-05
)
}
\arguments{
\item{U}{A length-one numeric signifying the number of cities to be represented in the spatPomp object.}

\item{dt}{a numeric (in unit of years) that is used as the Euler time-increment for simulating measles data.}

\item{fixed_ivps}{a logical. If \code{TRUE} initial value parameters will be
declared in the \code{globals} slot, shared for each unit, and
will not be part of the parameter vector.}

\item{S_0}{a numeric. If \code{fixed_ivps=TRUE} this is the initial proportion of all of the spatial units that are susceptible.}

\item{E_0}{a numeric. If \code{fixed_ivps=TRUE} this is the initial proportion of all of the spatial units that are exposed.}

\item{I_0}{a numeric. If \code{fixed_ivps=TRUE} this is the initial proportion of all of the spatial units that are infected.}
}
\value{
An object of class \sQuote{spatPomp} representing a \code{U}-dimensional spatially coupled measles POMP model.
}
\description{
Generate a spatPomp object for measles in the top-\code{U} most populous cities in England and Wales.
The model is adapted from He et al. (2010) with gravity transport following Park and Ionides (2020).
The data are from Dalziel et al (2016).
}
\note{
This function goes through a typical workflow of constructing
a typical spatPomp object (1-4 below). This allows the user to have a
file that replicates the exercise of model building as well as function
that creates a typical nonlinear model in epidemiology in case they want
to test a new inference methodology. We purposely do not modularize this
function because it is not an operational piece of the package and is
instead useful as an example.\cr
1. Getting a measurements data.frame with columns for times,
   spatial units and measurements.\cr
2. Getting a covariates data.frame with columns for times,
   spatial units and covariate data.\cr
3. Constructing model components (latent state initializer,
   latent state transition simulator and measurement model). Depending
   on the methods used, the user may have to supply a vectorfield to
   be integrated that represents the deterministic skeleton of the latent
   process.\cr
4. Bringing all the data and model components together to form a
   spatPomp object via a call to spatPomp().
}
\section{Relationship to published analysis}{

This model was used to generate the results of Ionides et al (2021).
However, their equation (6) is not exactly correct for the Binomial Gamma infinitesimal model used in the code, as shown by Proposition 5 of Breto and Ionides, 2011.
If Poisson Gamma infinitesimal increments were used (Proposition 4 of Breto and Ionides, 2011) then (6) would be correct, but the resulting unbounded increments could break the non-negativity requirement for compartment membership.
The same issue arises with the description in Park and Ionides (2020), though that analysis was based on a different model implementation since the spatPomp package was not yet available.

A difference between (6) of Ionides et al (2021) and (2.1) of He et al (2010) is that in (6) the mixing exponent \eqn{\alpha} is applied to \eqn{(I_u/P_u)} rather than just to \eqn{I_u}.
In the context of He et al (2010) this changes the parameterization but has negligible effect on the model itself since \eqn{P_u(t)} is approximately constant and so changing its power can be compensated by a corresponding change in the transmission rate, \eqn{\beta}.
In practice, models fitted to data have \eqn{alpha} close to \eqn{1}, so this issue may be moot and  this modeling mechanism may not be an effective empirical way to carry out the goal of making allowance for heterogeneous mixing.

The code here includes a cohort effect, \eqn{c}, following He et al (2010), that was not included by Ionides et al (2021).
This effect leads to a non-differentiability of expected increments which is problematic for the spatPomp implementation of GIRF.
For the results of Ionides et al (2021), this was set to \eqn{c=0}.

The analysis of He et al (2010), and the model generated by \code{he10()}, use weekly aggregated cases.
Weekly reports were not available beyond the 20 cites studied by He et al (2010) so \code{measles()} relies on the biweekly reports used by Ionides et al (2021) and Ionides & Park (2020).

It turns out to be an important detail of the model by He et al (2010) that a delay is included between birth and entry into the susceptible compartment. 
He et al (2010) found a 4 year delay fits the data.
This value is fixed to be the variable \code{birth_delay} in the code for \code{measles()}.
The code for Ionides et al (2021) uses a 3 year delay, and the delay is not explained in the abbreviated model description.
In \code{measles()} we have reverted to the 4 year delay identified by He et al (2010).
}

\examples{
# Complete examples are provided in the package tests
\dontrun{
m <- measles(U = 5)
# See all the model specifications of the object
spy(m)
}
}
\references{
\ionides2021

\dalziel2016

\park2020

\breto2011
}
\seealso{
\code{measles_UK}, \code{city_data_UK}

Other spatPomp model generators: 
\code{\link{bm}()},
\code{\link{bm2}()},
\code{\link{gbm}()},
\code{\link{he10}()},
\code{\link{lorenz}()}
}
\author{
Edward L. Ionides
}
\concept{spatPomp model generators}
