oat_processParamSubsets <-
function(FILEPATH,PARAMETERS,NUMRUNSPERSAMPLE,MEASURES,RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,OUTPUTCOLEND,CSV_FILE_NAME,BASELINE,PMIN=NULL,PMAX=NULL,PINC=NULL,PARAMVALS=NULL,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	# CREATE THE MEDIAN DISTRIBUTION OVER THE SET OF RUNS FOR EACH PARAMETER SET, FOR EACH PARAMETER (AS THIS IS ONE AT A TIME)
	# SPARTAN VERSION 2: THESE MEDIANS ARE NOW STORED IN ONE SINGLE FILE, NOT PER PARAMETER VALUE AS IN SPARTAN 1.0-1.3. 
	# LATER PROCESSING NOW DEALS WITH THESE FILES ONLY.
	# NOTE FROM SPARTAN 2, THIS FILE CAN ONLY BE A CSV FILE - XML FILES OF THIS SIZE TAKE A LARGE AMOUNT OF TIME TO PROCESS

	if(is.null(TIMEPOINTS))
	{
		if(file.exists(FILEPATH))
		{
			print("Generating Median Response File (oat_processParamSubsets)")

			# NOW ALL THE MEDIANS ARE HELD TOGETHER, ACCOMPANIED BY THEIR SIMULATION PARAMETERS BEING ANALYSED
			ALL_MEDIAN_RESULTS<-NULL
			
			# Check the Measures and Parameters for Spaces - R will have replaced these with a dot
			MEASURES<-table_header_check(MEASURES)

			# THE WAY WE DO OUR SIMULATIONS, WITH THE OLD FOLDER STRUCTURE, THE BASELINE WILL BE SIMULATED FOR EACH PARAMETER IN
			# ROBUSTNESS ANALYSIS. THERE IS NO NEED TO PERFORM THE ANALYSIS AGAIN AND AGAIN (AS WOULD HAPPEN WHEN WE INCREMENT THROUGH
			# THE VALUES. THUS, WE DO THE BASELINE WHEN FIRST DETECTED, AND IGNORE IT LATER. THIS FLAG ENSURES THIS HAPPENS
			BASELINEFLAG<-0

			for(PARAM in 1:length(PARAMETERS))
			{
				EXP_PARAMS<-as.character(BASELINE)

				# SET THE VALUE TO ITS LOWEST LIMIT
				PARAMVAL<-PMIN[PARAM]
		
				if(file.exists(paste(FILEPATH,"/",PARAMETERS[PARAM],sep="")))
				{
					# NOW WE CAN WORK WITH INCREMENTS BETWEEN MAX AND MIN, AND SPECIFIED VALUES, WE NEED TO GET THE VALUES
					# OF THE PARAMETERS WE ARE ANALYSING
					# NOTE THE CONVERSION BACK TO NUMBERS - GETS RID OF TRAILING ZEROS MADE BY SEQ
					PARAM_VAL_LIST<-as.numeric(prepare_parameter_value_list(PMIN,PMAX,PINC,PARAMVALS,PARAM))
		
					# NOW WE ITERATE THROUGH THE VALUES IN THIS LIST
					for(PARAMVAL in 1:length(PARAM_VAL_LIST))
					{
						# SET THE VALUE OF THE PARAMETERS BEING EXAMINED TO INCLUDE THE CURRENT VALUE OF THE PARAMETER
						EXP_PARAMS[PARAM] <- as.character(PARAM_VAL_LIST[PARAMVAL])

						if(PARAM_VAL_LIST[PARAMVAL]!=BASELINE[PARAM] || BASELINEFLAG==0)
						{
							if(file.exists(paste(FILEPATH,"/",PARAMETERS[PARAM],"/",toString(PARAM_VAL_LIST[PARAMVAL]),sep="")))
							{
								print(paste("Generating Median Results for Parameter: ",PARAMETERS[PARAM],", Value: ",PARAM_VAL_LIST[PARAMVAL],sep=""))

								# CREATE THE START OF THE FILE ADDRESS WHERE THE RESULTS FOR THIS PARAMETER ARE
								SAMPLEFILEPATH <- paste(FILEPATH,"/",PARAMETERS[PARAM],"/",toString(PARAM_VAL_LIST[PARAMVAL]),"/",sep="")
		
								RESULTS<-NULL
								
								# NOW CALL THE MEDIAN FUNCTIONS METHOD TO GET THE DISTRIBUTION FOR THIS SET OF RUNS
								MEDIAN_RESULTS<-getMediansSubset(SAMPLEFILEPATH,NUMRUNSPERSAMPLE,MEASURES,
												RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,OUTPUTCOLEND)

								# NOW WE NEED TO REPLICATE THE PARAMETER CONDITIONS THESE WERE OBTAINED UNDER FOR THE NUMBER OF MEDIAN RESULTS
								PARAMS<-NULL						
								for(p in 1:length(EXP_PARAMS))
								{
									PARAMS<-cbind(PARAMS,array(as.numeric(EXP_PARAMS[p]),dim=c(nrow(MEDIAN_RESULTS))))

								}
								# NOW BIND THESE TO THE RESULTS
								PARAMRESULT<-cbind(PARAMS,MEDIAN_RESULTS)						
								# NOW ADD THIS TO THE LIST OF ALL MEDIANS BEING PROCESSED IN THIS ANALYSIS
								ALL_MEDIAN_RESULTS<-rbind(ALL_MEDIAN_RESULTS,PARAMRESULT)

							}
							else
							{
								print(paste("No results can be found for parameter: ",PARAMETERS[PARAM]," Value: ",PARAMVAL,sep=""))
							}

							if(PARAM_VAL_LIST[PARAMVAL]==BASELINE[PARAM])
							{
								BASELINEFLAG<-1
							}

					
						}
					}
				}
				else
				{
					print(paste("No results can be found for the parameter specified: ",PARAMETERS[PARAM],sep=""))
				}
			}

			# NOW OUTPUT ALL THE MEDIAN RESULTS TO THE SPECIFIED FILEPATH
			colnames(ALL_MEDIAN_RESULTS)<-c(PARAMETERS,MEASURES)

			# OUTPUT IF THE RESULTS ARE NOT BLANK
			if(!is.null(ALL_MEDIAN_RESULTS))
			{
				RESULTSFILE = paste(FILEPATH,"/",CSV_FILE_NAME,sep="")
				print(paste("Writing Median Results to CSV File: ",RESULTSFILE,sep=""))
				write.csv(ALL_MEDIAN_RESULTS,RESULTSFILE,quote = FALSE,row.names=FALSE)
			}
		}
		else
		{
			print("The directory specified in FILEPATH does not exist. No analysis completed")
		}
	}
	else
	{
		# PROCESS EACH TIMEPOINT, BY AMENDING THE FILENAMES AND RECALLING THIS FUNCTION
		for(n in 1:length(TIMEPOINTS))
		{

			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			RESULTFILEFORMAT<-substr(RESULTFILENAME,(nchar(RESULTFILENAME)+1)-3,nchar(RESULTFILENAME))

			SIMRESULTFILENAME<-paste(substr(RESULTFILENAME,0,nchar(RESULTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
		
			if(!is.null(ALTERNATIVEFILENAME))
			{
				ALTERNATIVEFILENAMEFULL<-paste(substr(ALTERNATIVEFILENAME,0,nchar(ALTERNATIVEFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
			}else
			{
				ALTERNATIVEFILENAMEFULL<-ALTERNATIVEFILENAME
			}

			CSV_FILE_NAMEFORMAT<-substr(CSV_FILE_NAME,(nchar(CSV_FILE_NAME)+1)-3,nchar(CSV_FILE_NAME))

			CSV_FILE_NAMEFULL<-paste(substr(CSV_FILE_NAME,0,nchar(CSV_FILE_NAME)-4),"_",TIMEPOINTPROCESSING,".",CSV_FILE_NAMEFORMAT,sep="")

			# NOW CALL THIS FUNCTION AGAIN TO DO THE TIMEPOINTS - WE SET THE TIMEPOINTS AND TIMEPOINTSCALE TO NULL NOW SO WE DONT END UP BACK IN THIS ELSE

			oat_processParamSubsets(FILEPATH,PARAMETERS,NUMRUNSPERSAMPLE,MEASURES,SIMRESULTFILENAME,ALTERNATIVEFILENAMEFULL,OUTPUTCOLSTART,OUTPUTCOLEND,
				CSV_FILE_NAMEFULL,BASELINE,PMIN,PMAX,PINC,PARAMVALS,NULL,NULL)
		}
	}
}

