% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.sparsestep.R
\name{coef.sparsestep}
\alias{coef}
\alias{coef.sparsestep}
\title{Get the coefficients of a fitted SparseStep model}
\usage{
\method{coef}{sparsestep}(object, ...)
}
\arguments{
\item{object}{a \code{sparsestep} object}

\item{\dots}{further argument are ignored}
}
\value{
The coefficients of the SparseStep model (i.e. the betas) as a 
dgCMatrix. If the model was fitted with an intercept this will be the first
row in the resulting matrix.
}
\description{
Returns the coefficients of the SparseStep model.
}
\examples{
x <- matrix(rnorm(100*20), 100, 20)
y <- rnorm(100)
fit <- sparsestep(x, y)
coef(fit)

}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen, Andreas Alfons\cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
\references{
Van den Burg, G.J.J., Groenen, P.J.F. and Alfons, A. (2017).
 \emph{SparseStep: Approximating the Counting Norm for Sparse Regularization},
 arXiv preprint arXiv:1701.06967 [stat.ME]. 
 URL \url{https://arxiv.org/abs/1701.06967}.
}

