% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv.sparsegl}
\alias{cv.sparsegl}
\alias{cv.ls}
\title{Cross-validation for a \code{sparsegl} object.}
\usage{
cv.sparsegl(
  x,
  y,
  group = NULL,
  family = c("gaussian", "binomial"),
  lambda = NULL,
  pred.loss = c("L2", "L1", "binomial", "misclass"),
  nfolds = 10,
  foldid = NULL,
  ...
)
}
\arguments{
\item{x}{Double. A matrix of predictors, of dimension
\eqn{n \times p}{n * p}; each row
is a vector of measurements and each column is a feature. Objects of class
\code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix}} are supported.}

\item{y}{Double/Integer/Factor. The response variable.
Quantitative for \code{family="gaussian"}.
For \code{family="binomial"} should be either a factor with two levels or
a vector of integers taking 2 unique values.
For a factor, the last level in alphabetical order is the target class.}

\item{group}{Integer. A vector of consecutive integers describing the
grouping of the coefficients (see example below).}

\item{family}{Character. Specifies the loss function to use, valid
options are:
\itemize{
\item \code{"gaussian"} - least squares loss (regression, the default),
\item \code{"binomial"} - logistic loss (classification)
}}

\item{lambda}{A user supplied \code{lambda} sequence. The default, \code{NULL}
results in an automatic computation based on \code{nlambda}, the smallest value
of \code{lambda} that would give the null model (all coefficient estimates equal
to zero), and \code{lambda.factor}. Supplying a value of \code{lambda} overrides
this behaviour. It is likely better to supply a
decreasing sequence of \code{lambda} values than a single (small) value. If
supplied, the user-defined \code{lambda} sequence is automatically sorted in
decreasing order.}

\item{pred.loss}{Loss to use for cross-validation error. Valid options are:
\itemize{
\item \code{"L2"} for regression, mean square error
\item \code{"L1"} for regression, mean absolute error
\item \code{"binomial"} for classification, binomial deviance loss
\item \code{"misclass"} for classification, misclassification error.
}}

\item{nfolds}{Number of folds - default is 10. Although \code{nfolds} can be
as large as the sample size (leave-one-out CV), it is not recommended for
large datasets. Smallest value allowable is \code{nfolds = 3}.}

\item{foldid}{An optional vector of values between 1 and \code{nfolds}
identifying which fold each observation is in. If supplied, \code{nfolds} can
be missing.}

\item{...}{Other arguments that can be passed to sparsegl.}
}
\value{
An object of class \code{\link[=cv.sparsegl]{cv.sparsegl()}} is returned, which is a
list with the ingredients of the cross-validation fit.
\item{lambda}{The values of \code{lambda} used in the fits.}
\item{cvm}{The mean cross-validated error - a vector of
length \code{length(lambda)}.}
\item{cvsd}{Estimate of standard error of \code{cvm}.}
\item{cvupper}{Upper curve = \code{cvm + cvsd}.}
\item{cvlower}{Lower curve = \code{cvm - cvsd}.}
\item{name}{A text string indicating type of measure (for plotting
purposes).}
\item{sparsegl.fit}{A fitted \code{\link[=sparsegl]{sparsegl()}} object for the full data.}
\item{lambda.min}{The optimal value of \code{lambda} that gives
minimum cross validation error \code{cvm}.}
\item{lambda.1se}{The largest value of \code{lambda} such that error
is within 1 standard error of the minimum.}
}
\description{
Does k-fold cross-validation for \code{\link[=sparsegl]{sparsegl()}}.
This function is largely similar \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}.
}
\details{
The function runs \code{\link[=sparsegl]{sparsegl()}} \code{nfolds + 1} times; the first to
get the \code{lambda} sequence, and then the remainder to compute the fit
with each of the folds omitted. The average error and standard deviation
over the folds are computed.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
cv_fit <- cv.sparsegl(X, y, groups)

}
\seealso{
\code{\link[=sparsegl]{sparsegl()}}, \code{\link[=plot.cv.sparsegl]{plot.cv.sparsegl()}},
\code{\link[=predict.cv.sparsegl]{predict.cv.sparsegl()}}, and \code{\link[=coef.cv.sparsegl]{coef.cv.sparsegl()}} methods.
}
