% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cytometryContinuous}
\alias{cytometryContinuous}
\title{The continuous cytometry network}
\format{A \code{\link{list}} with three components:

\itemize{
\item \code{dag} An \code{\link[sparsebnUtils]{edgeList}} containing the consensus network (11 nodes, 17 edges).
\item \code{data} A \code{\link{data.frame}} with 11 variables and 7466 observations.
\item \code{ivn} A \code{\link{list}} specifying which nodes are under intervention in each observation.
Compatible with the input to \code{\link[sparsebnUtils]{sparsebnData}}.
}}
\usage{
data(cytometryContinuous)
}
\description{
Data and network for analyzing the flow cytometry experiment
from \href{http://science.sciencemag.org/content/308/5721/523.long}{Sachs et al. (2005)}.
This dataset contains the raw measurements from these experiments.
}
\examples{
# Create a valid sparsebnData object from the cytometry data
data(cytometryContinuous)
dat <- sparsebnData(cytometryContinuous$data, type = "c", ivn = cytometryContinuous$ivn)

}
\keyword{datasets}

