% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_spark.R
\name{registerDoSpark}
\alias{registerDoSpark}
\title{Register a Parallel Backend}
\usage{
registerDoSpark(spark_conn, parallelism = NULL, ...)
}
\arguments{
\item{spark_conn}{Spark connection to use}

\item{parallelism}{Level of parallelism to use for task execution
(if unspecified, then it will take the value of
 `SparkContext.defaultParallelism()` which by default is the number
 of cores available to the `sparklyr` application)}

\item{...}{additional options for sparklyr parallel backend
(currently only the only valid option is `nocompile`)}
}
\value{
None
}
\description{
Registers a parallel backend using the \code{foreach} package.
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")
registerDoSpark(sc, nocompile = FALSE)
}

}
