/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.ByteArrayOutputStream;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sparklyr.ArrowBatchStreamWriter;
import sparklyr.ArrowConvertersImpl;
import sparklyr.ArrowRowIterator;
import sparklyr.Invoke;
import sparklyr.Logger;

public final class ArrowConverters$ {
    public static final ArrowConverters$ MODULE$;

    static {
        new ArrowConverters$();
    }

    public Iterator<Row> fromPayloadArray(byte[][] records, StructType schema) {
        TaskContext$.MODULE$.get();
        Iterator singleRecords = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])records).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(byte[] record) {
                return record;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).iterator();
        ArrowRowIterator iter = new ArrowConvertersImpl().fromPayloadIterator((Iterator<byte[]>)singleRecords, (Option<TaskContext>)Option$.MODULE$.empty());
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)schema);
        return iter.map((Function1)new Serializable(converter){
            public static final long serialVersionUID = 0L;
            private final Function1 converter$1;

            public final Row apply(InternalRow x$1) {
                return (Row)this.converter$1.apply((Object)x$1);
            }
            {
                this.converter$1 = converter$1;
            }
        });
    }

    public Dataset<byte[]> toArrowDataset(Dataset<Row> df, SparkSession sparkSession, String timeZoneId) {
        StructType schema = df.schema();
        int maxRecordsPerBatch = sparkSession.sessionState().conf().arrowMaxRecordsPerBatch();
        Encoder encoder = Encoders$.MODULE$.BINARY();
        return df.mapPartitions((Function1)new Serializable(timeZoneId, schema, maxRecordsPerBatch){
            public static final long serialVersionUID = 0L;
            private final String timeZoneId$1;
            private final StructType schema$1;
            private final int maxRecordsPerBatch$2;

            public final Iterator<byte[]> apply(Iterator<Row> iter) {
                return new ArrowConvertersImpl().toBatchIterator(iter, this.schema$1, this.maxRecordsPerBatch$2, this.timeZoneId$1, TaskContext$.MODULE$.get());
            }
            {
                this.timeZoneId$1 = timeZoneId$1;
                this.schema$1 = schema$1;
                this.maxRecordsPerBatch$2 = maxRecordsPerBatch$2;
            }
        }, encoder);
    }

    public byte[] toArrowStream(Dataset<Row> df, String timeZoneId, Iterator<byte[]> batchIter) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowBatchStreamWriter batchWriter = new ArrowBatchStreamWriter(df.schema(), out, timeZoneId);
        batchWriter.writeOneBatch(batchIter);
        batchWriter.end();
        return out.toByteArray();
    }

    public byte[] toArrowBatchRdd(Dataset<Row> df, SparkSession sparkSession, String timeZoneId) {
        byte[][] batches = (byte[][])this.toArrowDataset(df, sparkSession, timeZoneId).collect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowBatchStreamWriter batchWriter = new ArrowBatchStreamWriter(df.schema(), out, timeZoneId);
        batchWriter.writeBatches((Iterator<byte[]>)Predef$.MODULE$.refArrayOps((Object[])batches).iterator());
        batchWriter.end();
        return out.toByteArray();
    }

    public Dataset<Row> toDataFrame(JavaRDD<byte[]> payloadRDD, StructType schema, SparkSession sparkSession) {
        return this.toDataFrame((RDD<byte[]>)payloadRDD.rdd(), schema, sparkSession);
    }

    public Dataset<Row> toDataFrame(RDD<byte[]> payloadRDD, StructType schema, SparkSession sparkSession) {
        RDD rdd = payloadRDD.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrowRowIterator apply(Iterator<byte[]> iter) {
                ArrowConvertersImpl converters = new ArrowConvertersImpl();
                TaskContext context = TaskContext$.MODULE$.get();
                return converters.fromPayloadIterator(iter, context);
            }
        }, payloadRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        Logger logger = new Logger("Arrow", 0);
        Invoke invoke2 = new Invoke();
        return (Dataset)invoke2.invoke(sparkSession.sqlContext().getClass(), "", sparkSession.sqlContext(), "internalCreateDataFrame", new Object[]{rdd, schema, BoxesRunTime.boxToBoolean((boolean)false)}, logger);
    }

    private ArrowConverters$() {
        MODULE$ = this;
    }
}

