/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import sparklyr.BoundedPriorityQueue;
import sparklyr.SamplingUtils;

public final class SamplingUtils$ {
    public static SamplingUtils$ MODULE$;

    static {
        new SamplingUtils$();
    }

    public RDD<Row> sampleWithoutReplacement(RDD<Row> rdd, String weightColumn, int k, long seed) {
        RDD mapRDDs;
        SparkContext sc = rdd.context();
        return 0 == k ? sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class)) : (0 == (mapRDDs = rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, iter) -> SamplingUtils$.$anonfun$sampleWithoutReplacement$1(seed, k, weightColumn, BoxesRunTime.unboxToInt((Object)index), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(BoundedPriorityQueue.class))).partitions().length ? sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class)) : sc.parallelize((Seq)((TraversableOnce)mapRDDs.reduce((Function2 & Serializable & scala.Serializable)(pq1, pq2) -> {
            pq1.$plus$plus$eq((TraversableOnce)pq2);
            return pq1;
        })).toSeq().map((Function1 & Serializable & scala.Serializable)x -> x.row(), Seq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)));
    }

    public RDD<Row> sampleWithReplacement(RDD<Row> rdd, String weightColumn, int k, long seed) {
        RDD mapRDDs;
        SparkContext sc = rdd.context();
        return 0 == k ? sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class)) : (0 == (mapRDDs = rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, iter) -> SamplingUtils$.$anonfun$sampleWithReplacement$1(seed, k, weightColumn, BoxesRunTime.unboxToInt((Object)index), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(SamplingUtils.Sample.class)))).partitions().length ? sc.emptyRDD(ClassTag$.MODULE$.apply(Row.class)) : sc.parallelize((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapRDDs.reduce((Function2 & Serializable & scala.Serializable)(s1, s2) -> {
            scala.package$.MODULE$.Range().apply(0, k).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                block0: {
                    if (!s1[idx].$less(s2[idx])) break block0;
                    s1$1[idx] = s2[idx];
                }
            });
            return s1;
        }))).map((Function1 & Serializable & scala.Serializable)x -> x.row(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)));
    }

    public double genSamplePriority(double weight, Random random) {
        return package$.MODULE$.log(random.nextDouble()) / weight;
    }

    public double extractWeightValue(Row row, String weightColumn) {
        Object weight;
        return weightColumn == null || weightColumn.isEmpty() ? 1.0 : ((weight = row.get(row.fieldIndex(weightColumn))) instanceof Integer || weight instanceof Integer ? (double)BoxesRunTime.unboxToInt((Object)weight) : (weight instanceof Long || weight instanceof Long ? (double)BoxesRunTime.unboxToLong((Object)weight) : (weight instanceof Double || weight instanceof Double ? BoxesRunTime.unboxToDouble((Object)weight) : (weight instanceof BigDecimal ? ((BigDecimal)weight).doubleValue() : Double.NaN))));
    }

    public static final /* synthetic */ Iterator $anonfun$sampleWithoutReplacement$1(long seed$1, int k$1, String weightColumn$1, int index, Iterator iter) {
        Random random = new Random(seed$1 + (long)index);
        BoundedPriorityQueue pq = new BoundedPriorityQueue(k$1, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            BoxedUnit boxedUnit;
            double weight = MODULE$.extractWeightValue((Row)row, weightColumn$1);
            if (weight > 0.0) {
                SamplingUtils.Sample sample = new SamplingUtils.Sample(MODULE$.genSamplePriority(weight, random), (Row)row);
                boxedUnit = pq.$plus$eq(sample);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return scala.package$.MODULE$.Iterator().single(pq);
    }

    public static final /* synthetic */ void $anonfun$sampleWithReplacement$3(String weightColumn$2, int k$2, Random random$2, SamplingUtils.Sample[] samples$1, Row row) {
        block0: {
            DoubleRef weight = DoubleRef.create((double)MODULE$.extractWeightValue(row, weightColumn$2));
            if (!(weight.elem > 0.0)) break block0;
            scala.package$.MODULE$.Range().apply(0, k$2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                block0: {
                    SamplingUtils.Sample replacement = new SamplingUtils.Sample(MODULE$.genSamplePriority(weight$1.elem, random$2), row);
                    if (!samples$1[idx].$less(replacement)) break block0;
                    samples$1[idx] = replacement;
                }
            });
        }
    }

    public static final /* synthetic */ Iterator $anonfun$sampleWithReplacement$1(long seed$2, int k$2, String weightColumn$2, int index, Iterator iter) {
        Random random = new Random(seed$2 + (long)index);
        SamplingUtils.Sample[] samples = (SamplingUtils.Sample[])Array$.MODULE$.fill(k$2, (Function0 & Serializable & scala.Serializable)() -> new SamplingUtils.Sample(Double.NEGATIVE_INFINITY, null), ClassTag$.MODULE$.apply(SamplingUtils.Sample.class));
        iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            SamplingUtils$.$anonfun$sampleWithReplacement$3(weightColumn$2, k$2, random, samples, row);
            return BoxedUnit.UNIT;
        });
        return scala.package$.MODULE$.Iterator().single((Object)samples);
    }

    private SamplingUtils$() {
        MODULE$ = this;
    }
}

