% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_transformation.R
\name{ft_string_indexer}
\alias{ft_string_indexer}
\title{Feature Transformation -- StringIndexer}
\usage{
ft_string_indexer(x, input.col, output.col, params = NULL, ...)
}
\arguments{
\item{x}{An object (usually a \code{spark_tbl}) coercable to a Spark DataFrame.}

\item{input.col}{The name of the input column(s).}

\item{output.col}{The name of the output column.}

\item{params}{An (optional) \R environment -- when available,
the index <-> label mapping generated by the string indexer
will be injected into this environment under the \code{labels}
key.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Encode a column of labels into a column of label indices.
The indices are in [0, numLabels), ordered by label frequencies, with
the most frequent label assigned index 0. The transformation
can be reversed with \code{\link{ft_index_to_string}}.
}
\seealso{
See \url{http://spark.apache.org/docs/latest/ml-features.html} for
  more information on the set of transformations available for DataFrame
  columns in Spark.

Other feature transformation routines: \code{\link{ft_binarizer}},
  \code{\link{ft_bucketizer}},
  \code{\link{ft_count_vectorizer}},
  \code{\link{ft_discrete_cosine_transform}},
  \code{\link{ft_elementwise_product}},
  \code{\link{ft_index_to_string}},
  \code{\link{ft_one_hot_encoder}},
  \code{\link{ft_quantile_discretizer}},
  \code{\link{ft_regex_tokenizer}},
  \code{\link{ft_stop_words_remover}},
  \code{\link{ft_tokenizer}},
  \code{\link{ft_vector_assembler}},
  \code{\link{sdf_mutate}}
}
