% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{summarize_stddev}
\alias{summarize_stddev}
\title{Standard deviation summarizer}
\usage{
summarize_stddev(ts_rdd, column, window = NULL, key_columns = list())
}
\arguments{
\item{ts_rdd}{Timeseries RDD being summarized}

\item{column}{Column to be summarized}

\item{window}{Either a R expression specifying time windows to be summarized
(e.g., `in_past("1h")` to summarize data from looking behind 1 hour at
each time point, `in_future("5s")` to summarize data from looking forward
5 seconds at each time point), or `NULL` to compute aggregate statistics
on rows grouped by timestamps}

\item{key_columns}{Optional list of columns that will form an equivalence
relation associating each row with the time series it belongs to (i.e., any
2 rows having equal values in those columns will be associated with the
same time series, and any 2 rows having differing values in those columns
are considered to be from 2 separate time series and will therefore be
summarized separately)
By default, `key_colums` is empty and all rows are considered to be part of
a single time series.}
}
\value{
A TimeSeriesRDD containing the summarized result
}
\description{
Compute unbiased (i.e., Bessel's correction is applied) sample standard
deviation of values from `column` within each time window or within each
group of rows with identical timestamps, and store results in a new column
named `<column>_stddev`
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = seq(10)))
  ts <- fromSDF(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_stddev <- summarize_stddev(ts, column = "v", window = in_past("3s"))
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other summarizers: 
\code{\link{summarize_avg}()},
\code{\link{summarize_corr2}()},
\code{\link{summarize_corr}()},
\code{\link{summarize_count}()},
\code{\link{summarize_covar}()},
\code{\link{summarize_dot_product}()},
\code{\link{summarize_max}()},
\code{\link{summarize_min}()},
\code{\link{summarize_nth_central_moment}()},
\code{\link{summarize_nth_moment}()},
\code{\link{summarize_product}()},
\code{\link{summarize_quantile}()},
\code{\link{summarize_sum}()},
\code{\link{summarize_var}()},
\code{\link{summarize_weighted_avg}()},
\code{\link{summarize_weighted_corr}()},
\code{\link{summarize_weighted_covar}()},
\code{\link{summarize_z_score}()}
}
\concept{summarizers}
