% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_display.R
\name{image.mrs_data}
\alias{image.mrs_data}
\title{Image plot method for objects of class mrs_data.}
\usage{
\method{image}{mrs_data}(
  x,
  xlim = NULL,
  mode = "re",
  col = NULL,
  plot_dim = NULL,
  x_pos = NULL,
  y_pos = NULL,
  z_pos = NULL,
  dyn = 1,
  coil = 1,
  restore_def_par = TRUE,
  y_ticks = NULL,
  hline = NULL,
  hline_lty = 2,
  hline_col = "white",
  vline = NULL,
  vline_lty = 2,
  vline_col = "white",
  legend = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class mrs_data.}

\item{xlim}{the range of values to display on the x-axis, eg xlim = c(4,1).}

\item{mode}{representation of the complex numbers to be plotted, can be one
of: "re", "im", "mod" or "arg".}

\item{col}{Colour map to use, defaults to viridis.}

\item{plot_dim}{the dimension to display on the y-axis, can be one of: "dyn",
"time_sec", x", "y", "z", "coil" or NULL. If NULL (the default) all spectra
are collapsed into the dynamic dimension and displayed.}

\item{x_pos}{the x index to plot.}

\item{y_pos}{the y index to plot.}

\item{z_pos}{the z index to plot.}

\item{dyn}{the dynamic index to plot.}

\item{coil}{the coil element number to plot.}

\item{restore_def_par}{restore default plotting par values after the plot has
been made.}

\item{y_ticks}{a vector of indices specifying where to place additional red
tick marks.}

\item{hline}{add a horizontal line at the specified value.}

\item{hline_lty}{linetype for the horizontal line.}

\item{hline_col}{colour for the horizontal line.}

\item{vline}{add a vertical line at the specified value.}

\item{vline_lty}{linetype for the vertical line.}

\item{vline_col}{colour for the vertical line.}

\item{legend}{add a colour bar to the plot using the imagePlot function
from the fields package.}

\item{...}{other arguments to pass to the plot method.}
}
\description{
Image plot method for objects of class mrs_data.
}
