% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{spec_op}
\alias{spec_op}
\title{Perform a mathematical operation on a spectral region.}
\usage{
spec_op(
  mrs_data,
  xlim = NULL,
  operator = "sum",
  freq_scale = "ppm",
  mode = "re"
)
}
\arguments{
\item{mrs_data}{MRS data.}

\item{xlim}{spectral range to be integrated (defaults to full range).}

\item{operator}{can be "sum" (default), "mean", "l2", "max", "min" or
"max-min".}

\item{freq_scale}{units of xlim, can be : "ppm", "hz" or "points".}

\item{mode}{spectral mode, can be : "re", "im", "mod" or "cplx".}
}
\value{
an array of integral values.
}
\description{
Perform a mathematical operation on a spectral region.
}
