% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abfit.R
\name{abfit_opts}
\alias{abfit_opts}
\title{Return a list of options for an ABfit analysis.}
\usage{
abfit_opts(
  init_damping = 5,
  maxiters = 1024,
  max_shift = 10,
  max_damping = 15,
  max_phase = 360,
  lambda = NULL,
  ppm_left = 4,
  ppm_right = 0.2,
  zp = TRUE,
  bl_ed_pppm = 2,
  auto_bl_flex = TRUE,
  bl_comps_pppm = 15,
  export_sp_fit = FALSE,
  max_asym = 0.25,
  max_basis_shift = 1,
  max_basis_damping = 2,
  maxiters_pre = 1000,
  algo_pre = "NLOPT_LN_NELDERMEAD",
  min_bl_ed_pppm = NULL,
  max_bl_ed_pppm = 7,
  auto_bl_flex_n = 20,
  pre_fit_bl_ed_pppm = 1,
  remove_lip_mm_prefit = FALSE,
  pre_align = TRUE,
  max_pre_align_shift = 0.1,
  pre_align_ref_freqs = c(2.01, 3.03, 3.22),
  noise_region = c(-0.5, -2.5),
  optimal_smooth_criterion = "maic",
  aic_smoothing_factor = 5,
  anal_jac = TRUE,
  pre_fit_ppm_left = 4,
  pre_fit_ppm_right = 1.8,
  phi1_optim = FALSE,
  phi1_init = 0,
  max_dphi1 = 0.2,
  max_basis_shift_broad = 1,
  max_basis_damping_broad = 2
)
}
\arguments{
\item{init_damping}{initial value of the Gaussian global damping parameter
(Hz). Very poorly shimmed or high field data may benefit from a larger value.}

\item{maxiters}{The maximum number of iterations to run for the detailed fit.}

\item{max_shift}{The maximum allowable shift to be applied in the
optimisation phase of fitting (Hz).}

\item{max_damping}{maximum permitted value of the global damping parameter
(Hz).}

\item{max_phase}{maximum permitted value of the global zero-order phase term
(degrees).}

\item{lambda}{manually set the the baseline smoothness parameter.}

\item{ppm_left}{downfield frequency limit for the fitting range (ppm).}

\item{ppm_right}{upfield frequency limit for the fitting range (ppm).}

\item{zp}{zero pad the data to twice the original length before fitting.}

\item{bl_ed_pppm}{manually set the the baseline smoothness parameter (ED per
ppm).}

\item{auto_bl_flex}{automatically determine the level of baseline smoothness.}

\item{bl_comps_pppm}{spline basis density (signals per ppm).}

\item{export_sp_fit}{add the fitted spline functions to the fit result.}

\item{max_asym}{maximum allowable value of the asymmetry parameter.}

\item{max_basis_shift}{maximum allowable frequency shift for individual basis
signals (Hz).}

\item{max_basis_damping}{maximum allowable Lorentzian damping factor for
individual basis signals (Hz).}

\item{maxiters_pre}{maximum iterations for the coarse (pre-)fit.}

\item{algo_pre}{optimisation method for the coarse (pre-)fit.}

\item{min_bl_ed_pppm}{minimum value for the candidate baseline flexibility
analyses (ED per ppm).}

\item{max_bl_ed_pppm}{minimum value for the candidate baseline flexibility
analyses (ED per ppm).}

\item{auto_bl_flex_n}{number of candidate baseline analyses to perform.}

\item{pre_fit_bl_ed_pppm}{level of baseline flexibility to use in the coarse
fitting stage of the algorithm (ED per ppm).}

\item{remove_lip_mm_prefit}{remove broad signals in the coarse fitting stage
of the algorithm.}

\item{pre_align}{perform a pre-alignment step before coarse fitting.}

\item{max_pre_align_shift}{maximum allowable shift in the pre-alignment step
(ppm).}

\item{pre_align_ref_freqs}{a vector of prominent spectral frequencies used in
the pre-alignment step (ppm).}

\item{noise_region}{spectral region to estimate the noise level (ppm).}

\item{optimal_smooth_criterion}{method to determine the optimal smoothness.}

\item{aic_smoothing_factor}{modification factor for the AIC calculation.}

\item{anal_jac}{use a analytical approximation to the jacobian in the
detailed fitting stage.}

\item{pre_fit_ppm_left}{downfield frequency limit for the fitting range in
the coarse fitting stage of the algorithm (ppm).}

\item{pre_fit_ppm_right}{upfield frequency limit for the fitting range in the
coarse fitting stage of the algorithm (ppm).}

\item{phi1_optim}{apply and optimise a frequency dependant phase term.}

\item{phi1_init}{initial value for the frequency dependant phase term (ms).}

\item{max_dphi1}{maximum allowable change from the initial frequency
dependant phase term (ms).}

\item{max_basis_shift_broad}{maximum allowable shift for broad signals in the
basis (Hz). Determined based on their name beginning with Lip or MM.}

\item{max_basis_damping_broad}{maximum allowable Lorentzian damping for broad
signals in the basis (Hz). Determined based on their name beginning with Lip
or MM.}
}
\value{
full list of options.
}
\description{
Return a list of options for an ABfit analysis.
}
\examples{
opts <- abfit_opts(ppm_left = 4.2, noise_region = c(-1, -3))
}
