# 'which' can be any way of indexing a list
getPar <- function(parlist,name,which=NULL) {
  if ( ! is.null(which)) parlist <- parlist[[which]] 
  val <- parlist[[name]] 
  if (is.null(val)) { ## ie name not found a topmost level; scan sublists:
    vallist <- lapply(parlist, function(sublist) {
      if (is.list(sublist)) {sublist[[name]]} else {NULL}
    })
    ll <- sapply(vallist,length)
    ll <- which(ll>0)
    if (length(ll)>1) {
      stop(paste("Found several instances of element '",name,"' in nested list: use 'which' to resolve this.",sep=""))
    } else if (length(ll)==0) {
      val <- NULL
    } else val <- vallist[[ll]]
  }
  val
}

# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"b") ## 2
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"c") ## 4
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"a") ## error
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"a",which=1) ## 1
# getPar(list("1"=list(a=1,b=2),"2"=list(a=3,c=4)),"d") ## NULL


predictionCoeffs <- function(object) {
  v_h_coeffs <- object$v_h ## v_h for non spatial and will later contain coeffs for spatial
  LMatrix <- attr(object$predictor,"LMatrix") 
  if ( ! is.null(LMatrix)) {
    vec_n_u_h <- attr(object$lambda,"n_u_h")
    cum_n_u_h <- cumsum(c(0,vec_n_u_h))  
    ZAlist <- object$ZAlist 
    if ( ! is.list(LMatrix)) LMatrix <- list(LMatrix)
    for (Lit in seq_len(length(LMatrix))) {
      lmatrix <- LMatrix[[Lit]]
      affecteds <- which(attr(ZAlist,"ranefs") %in% attr(lmatrix,"ranefs"))
      for (it in affecteds) {
        u.range <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
        v_h_coeffs[u.range] <- solve(t(lmatrix),v_h_coeffs[u.range])   
      }  
    }
  }
  return(v_h_coeffs)
}

getHLfit <- function(fitobject) {
  if (inherits(fitobject,"HLfit")) {
    fitobject    
  } else if (inherits(fitobject,"HLCor")) {
    fitobject$hlfit    
  } else if (inherits(fitobject,"corrHLfit")) {
    fitobject$hlfit    
  }
} 

fitted.HLfit <- function(object,...) {
  object <- getHLfit(object)
  object$fv
}

#ranef.HLfit <- function(object,ranef.class=TRUE,...) {
ranef.HLfit <- function(object,...) {
  object <- getHLfit(object)
  lambda.object <- object$lambda.object
  namesTerms <- lambda.object$namesTerms
  repGroupNames <- unlist(lapply(seq_len(length(namesTerms)),function(it) {
    names(namesTerms[[it]]) <- rep(names(namesTerms)[it],length(namesTerms[[it]]))
  })) ## makes group identifiers unique (names of coeffs are unchanged)
  coefficients <- unlist(lambda.object$namesTerms) ## FR->FR store this one for all in lambda.object ?
  ## cf Group and Term columns in output generated by summary.HL()
  nams <- paste(repGroupNames,coefficients) ## one name for each lambda coefficient
  res <- object$ranef #random effects \eqn{u}
  attr(res,"nams") <- nams
  # if (ranef.class) class(res) <- c("ranef",class(res))
  class(res) <- c("ranef",class(res))
  res
}

print.ranef <- function(x,...) {
  cum_n_u_h <- attr(x,"cum_n_u_h")
  nams <- attr(x,"nams")
  lapply(seq_len(length(nams)), function(it) {
    #cat(paste(nams[it], " (", cum_n_u_h[it + 1]-cum_n_u_h[it], " levels)\n",sep=""))    
    cat(paste(nams[it], " :\n",sep=""))    
    u.range <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
    print(x[u.range])
  })
  invisible(x)
}

fixef.HLfit <- function(object,...) {
  object <- getHLfit(object)
  object$fixef    
}

logLik.HLfit <- function(object, REML = FALSE, ...) {
  object <- getHLfit(object)
  if (REML) {
    return(object$APHLs$p_bv)
  } else {
    return(object$APHLs$p_v)
  }    
}

vcov.HLfit <- function(object,...) {
  object <- getHLfit(object)
  object$beta_cov
}


## FR logLik ?