% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_indexing_sf.R
\name{spatial_request}
\alias{spatial_request}
\title{Spatial request}
\usage{
spatial_request(geometry, tree, data)
}
\arguments{
\item{geometry}{sf like object (feature collection or simple geometry)}

\item{tree}{a tree object from package SearchTrees}

\item{data}{the original data used to build the tree object}
}
\value{
a subset of data, intersecting geometry
}
\description{
Use a quadtree index to perform spatial request.
}
\examples{
data(mtl_network)
tree <- build_quadtree(mtl_network)
buff <- sf::st_buffer(mtl_network[55,], 50)
selection <- spatial_request(buff, tree, mtl_network)
}
