% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gccm.R
\name{gccm}
\alias{gccm}
\alias{gccm,sf-method}
\alias{gccm,SpatRaster-method}
\title{geographical convergent cross mapping}
\usage{
\S4method{gccm}{sf}(
  data,
  cause,
  effect,
  libsizes,
  E = 3,
  tau = 1,
  k = E + 2,
  theta = 1,
  algorithm = "simplex",
  lib = NULL,
  pred = NULL,
  nb = NULL,
  threads = detectThreads(),
  parallel.level = "low",
  bidirectional = TRUE,
  trend.rm = TRUE,
  progressbar = TRUE
)

\S4method{gccm}{SpatRaster}(
  data,
  cause,
  effect,
  libsizes,
  E = 3,
  tau = 1,
  k = E + 2,
  theta = 1,
  algorithm = "simplex",
  lib = NULL,
  pred = NULL,
  threads = detectThreads(),
  parallel.level = "low",
  bidirectional = TRUE,
  trend.rm = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{The observation data.}

\item{cause}{Name of causal variable.}

\item{effect}{Name of effect variable.}

\item{libsizes}{Number of spatial units used in prediction.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors used in prediction.}

\item{theta}{(optional) Weighting parameter for distances, useful when \code{algorithm} is \code{smap}.}

\item{algorithm}{(optional) Algorithm used in prediction.}

\item{lib}{(optional) Libraries indices.}

\item{pred}{(optional) Predictions indices.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{parallel.level}{(optional) Level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{varname}}{names of causal and effect variable}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
geographical convergent cross mapping
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
g = gccm(columbus,"hoval","crime",libsizes = seq(5,45,5),E = 6)
g
plot(g, ylimits = c(0,0.85))
}
}
\references{
Gao, B., Yang, J., Chen, Z. et al. Causal inference from cross-sectional earth system data with geographical convergent cross mapping. Nat Commun 14, 5875 (2023).
}
