% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp500SlidingWindow.R
\name{sp500SlidingWindow}
\alias{sp500SlidingWindow}
\title{Sliding Window Investment Analysis}
\usage{
sp500SlidingWindow(investment_vector, withdrawal_vector, window_width = 30,
  annual_fee = 0.0125, output_path = "~/")
}
\arguments{
\item{investment_vector}{a vector of annual investments,
(positive values represent investment into the account), length must be window_width}

\item{withdrawal_vector}{a vector of annual withdrawals,
(positive values represent withdrawal from the account), length must be window_width}

\item{window_width}{the number of years in each window}

\item{annual_fee}{the total annual percent removed by the investment managers}

\item{output_path}{file path to a folder in which graphs & statistics will be saved}
}
\value{
data.frame with summary statistics for each window plus
 the side-effects of graphs written to the output_path given
}
\description{
Uses the S&P500 daily data on a series of windows and generates
graphs & statistics on the performance.
}
\details{
The daily market data for the S&P 500 from 1950 to the present
is broken into a series of periods or windows of equal length (except for
the last period). The investment and expense data provided is analyzed to
see how it would fare in each widow. Graphs and statistics are produced.
}
\examples{
\dontrun{
investment_vector <- seq(1,30)*10
withdrawal_vector <- c(investment_vector[1:10]  * 0.15,
                   investment_vector[11:20] * 0.35,
                   investment_vector[21:30] * runif(10, min=0.01, max=0.90))
window_df <- sp500SlidingWindow(investment_vector,
                               withdrawal_vector, output_path='~/Downloads/')
}

}
\author{
George Fisher
}

