% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_structure.R
\name{overlap_structure}
\alias{overlap_structure}
\title{Automatically generate objects used to describe the structure of the overlapping group lasso penalty}
\usage{
overlap_structure(group_list)
}
\arguments{
\item{group_list}{A list containing the indices of the group members.}
}
\value{
A list of objects describing the group structure.
  \item{groups}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to describe the relationship between the \eqn{G} \code{overlapping} groups. A \eqn{G * G} integer matrix whose \eqn{(i,j)} entry is \code{1} if and only if \eqn{i\neq j} and \eqn{g_i} is a child group (subset) of \eqn{g_j}, and is \code{0} otherwise.}
  \item{groups_var}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to describe the relationship between the \eqn{G} \code{overlapping} groups and the \eqn{p} variables. A \eqn{p * G} integer matrix whose \eqn{(i,j)} entry is \code{1} if and only if variable \eqn{i} is in group \eqn{g_j}, but not in any child group of \eqn{g_j}, and is \code{0} otherwise. }
  \item{group_weights}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to specify the group-specific penalty weights. The penalty weight for each group is equal to the square root of the group size.}
}
\description{
Automatically generate objects used to describe the structure of the overlapping group lasso penalty The output is then used by \code{\link{sox}()} and \code{\link{sox_cv}()}.
}
\examples{
# p = 9 Variables:
## 1: A1
## 2: A2
## 3: C1
## 4: C2
## 5: B
## 6: A1B
## 7: A2B
## 8: C1B
## 9: C2B

# G = 5 Overlapping groups:
## g1: A1, A2, A1B, A2B
## g2: B, A1B, A2B, C1B, C2B
## g3: A1B, A2B
## g4: C1, C2, C1B, C2B
## g5: C1B, C2B

overlapping.groups <- list(c(1, 2, 6, 7),
                           c(5, 6, 7, 8, 9),
                           c(6, 7),
                           c(3, 4, 8, 9),
                           c(8, 9))
                           
pars.overlapping <- overlap_structure(overlapping.groups)

str(pars.overlapping)
                
}
