% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_wrappers.R
\name{HD}
\alias{HD}
\title{Estimate historical decomposition}
\usage{
HD(model)
}
\arguments{
\item{model}{VAR or RVAR class object}
}
\value{
long-from data.frame
}
\description{
Estimate the historical decomposition for VARs with
either 'short' or 'IV-short' structural errors. See VAR
and RVAR documentation for details regarding structural errors.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate VAR
  var =
    sovereign::VAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      lag.ic = 'BIC',
      lag.max = 4)

# impulse response functions
var.irf = sovereign::IRF(var)

# forecast error variance decomposition
var.fevd = sovereign::FEVD(var)

# historical shock decomposition
var.hd = sovereign::HD(var)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_hd]{var_hd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_hd]{rvar_hd()}}
}
