% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum_utilities.R
\name{plotMS}
\alias{plotMS}
\title{Plot modulation spectrum}
\usage{
plotMS(
  ms,
  X = as.numeric(colnames(ms)),
  Y = as.numeric(rownames(ms)),
  quantiles = c(0.5, 0.8, 0.9),
  colorTheme = c("bw", "seewave", "heat.colors", "...")[1],
  col = NULL,
  logWarpX = NULL,
  logWarpY = NULL,
  main = NULL,
  xlab = "Hz",
  ylab = "1/kHz",
  xlim = NULL,
  ylim = NULL,
  audio = NULL,
  extraY = TRUE,
  ...
)
}
\arguments{
\item{ms}{modulation spectrum - a matrix with temporal modulation in columns
and spectral modulation in rows, as returned by
\code{\link{modulationSpectrum}}}

\item{X, Y}{rownames and colnames of \code{ms}, respectively}

\item{quantiles}{labeled contour values, \% (e.g., "50" marks regions that
contain 50\% of the sum total of the entire modulation spectrum)}

\item{colorTheme}{black and white ('bw'), as in seewave package ('seewave'),
matlab-type palette ('matlab'), or any palette from
\code{\link[grDevices]{palette}} such as 'heat.colors', 'cm.colors', etc}

\item{col}{actual colors, eg rev(rainbow(100)) - see ?hcl.colors for colors
in base R (overrides colorTheme)}

\item{logWarpX, logWarpY}{numeric vector of length 2: c(sigma, base) of
pseudolog-warping the modulation spectrum, as in function
pseudo_log_trans() from the "scales" package}

\item{xlab, ylab, main, xlim, ylim}{graphical parameters}

\item{audio}{(internal) a list of audio attributes}

\item{extraY}{if TRUE, another Y-axis is plotted on the right showing 1000/Y}

\item{...}{other graphical parameters passed on to \code{filled.contour.mod}
and \code{\link[graphics]{contour}} (see \code{\link{spectrogram}})}
}
\description{
Plots a single modulation spectrum returned by
\code{\link{modulationSpectrum}}. The result is the same as the plot produced
by \code{\link{modulationSpectrum}}, but calling \code{plotMS} is handy for
processed modulation spectra - for instance, for plotting the difference
between the modulation spectra of two sounds or groups of sounds.
}
\examples{
ms1 = modulationSpectrum(runif(4000), samplingRate = 16000, plot = TRUE)
plotMS(ms1$processed)  # identical to above

# compare two modulation spectra
ms2 = modulationSpectrum(soundgen(sylLen = 100, addSilence = 0),
                         samplingRate = 16000)
# ensure the two matrices have the same dimensions
ms2_resized = soundgen:::interpolMatrix(ms2$original,
  nr = nrow(ms1$original), nc = ncol(ms1$original))
# plot the difference
plotMS(log(ms1$original / ms2_resized), quantile = NULL,
  col = colorRampPalette(c('blue', 'yellow')) (50))
}
