% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{.flatEnv}
\alias{.flatEnv}
\title{Flat envelope per sound}
\usage{
.flatEnv(
  audio,
  compression = 1,
  method = c("hil", "rms", "peak")[1],
  windowLength = 50,
  windowLength_points = NULL,
  killDC = FALSE,
  dynamicRange = 40,
  plot = FALSE,
  col = "blue",
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{compression}{the amount of compression to apply: 0 = none, 1 = maximum}

\item{method}{hil = Hilbert envelope, rms = root mean square amplitude, peak
= peak amplitude per window}

\item{windowLength}{the length of smoothing window, ms}

\item{windowLength_points}{the length of smoothing window, points. If
specified, overrides \code{windowLength}}

\item{killDC}{if TRUE, dynamically removes DC offset or similar deviations of
average waveform from zero (see examples)}

\item{dynamicRange}{parts of sound quieter than \code{-dynamicRange} dB will
not be amplified}

\item{plot}{if TRUE, plots the original sound, the smoothed envelope, and
the compressed sound}

\item{col}{the color of amplitude contours}

\item{width, height, units, res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters passed to \code{points()} that control
the appearance of amplitude contours, eg \code{lwd, lty}, etc.}
}
\description{
Internal soundgen function
}
\keyword{internal}
