% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch_postprocessing.R
\name{interpolate}
\alias{interpolate}
\title{Interpolate}
\usage{
interpolate(
  pitchCands,
  pitchCert,
  pitchSource,
  pitchCenterGravity,
  interpolWin_bin = 3,
  interpolTol = 0.3,
  interpolCert = 0.3
)
}
\arguments{
\item{pitchCands}{a matrix of multiple pitch candidates per fft frame. Each
column is one fft frame, each row is one candidate (the last row is always
"manual")}

\item{pitchCert}{a matrix of the same dimensionality as pitchCands specifying
our certainty in pitch candidates}

\item{pitchCenterGravity}{numeric vector giving the mean of all pitch
candidates per fft frame weighted by our certainty in each of these
candidates}

\item{interpolWin_bin}{when interpolating pitch candidates, the median is
calculated over \code{plus-minus interpolWin_bin}}

\item{interpolTol}{when interpolating pitch candidates, the criterion
for needing to interpolate is the absence of pitch candidates with values
within \code{1 plus-minus interpolTol} of the median of pitch center of
gravity over the interpolation window. For ex., if \code{interpolTol}
is .05, we look for values from 0.95 to 1.05 time the median value over
interpolation window.}

\item{interpolCert}{when interpolating pitch candidates, all generated pitch
candidates are assigned a certainty equal to \code{interpolCert}}
}
\value{
Returns a modified pitchCands matrix.
}
\description{
Internal soundgen function.
}
\details{
Interpolation: if a frame has no pitch candidate at all (NA) or no candidate
between the most likely candidates for the adjacent frames, add such a
candidate with some (low) certainty.
}
\keyword{internal}
