% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loudness_utilities.R
\name{iso226}
\alias{iso226}
\title{iso226}
\usage{
iso226(phon, nBarks = 22)
}
\arguments{
\item{phon}{the phon value in dB SPL represented by the loudness curve}
}
\value{
A dataframe containing evaluated frequencies and SPL values
}
\description{
Internal soundgen function
}
\details{
Calculates equal loudness curves according to the ISO226 standard. Expected
range of input values in phon is 0 to 90 (1 phon is 1 dB at 1 kHz). The range
of evaluated frequencies is 20 to 12500 Hz, with a total of 29 values (so
upsample if more resolution is needed, but not that beyond 22 barks it's just
assumed to be flat). Translated from the matlab implementation by Jeff Tackett
(03/01/05) available from
"https://www.mathworks.com/matlabcentral/fileexchange/
7028-iso-226-equal-loudness-level-contour-signal"
}
\examples{
i = soundgen:::iso226(40)
plot(i$curve29, type = 'l')
plot(i$curveBark$freq_Hz, i$curveBark$spl, type = 'l')
}
\keyword{internal}
