% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{downsample}
\alias{downsample}
\title{Simple downsampling}
\usage{
downsample(s, srNew = 10, srOld = 120, minLen = 3)
}
\arguments{
\item{s}{a numeric vector}

\item{srNew}{the new, required sampling rate}

\item{srOld}{the original sampling rate}

\item{minLen}{the minimum length of returned vector}
}
\description{
Internal soundgen function
}
\details{
Takes a numeric vector and downsamples it to the required sampling rate by
applying a low-pass filter and then decimating. If the new sampling rate is
higher than the original, it does nothing.
}
\examples{
s = rnorm(100); plot(s, type = 'l')
s1 = soundgen:::downsample(s, srNew = 5, srOld = 18)
plot(s1, type = 'l', col = 'red')
plot(soundgen:::downsample(s, srNew = 5, srOld = 40), type = 'b')
}
\keyword{internal}
