% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{.flatSpectrum}
\alias{.flatSpectrum}
\title{Flat spectrum per sound}
\usage{
.flatSpectrum(
  audio,
  freqWindow = NULL,
  samplingRate = NULL,
  dynamicRange = 80,
  windowLength = 50,
  step = NULL,
  overlap = 90,
  wn = "gaussian",
  zp = 0,
  play = FALSE,
  saveAudio = NULL
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{freqWindow}{the width of smoothing window, Hz. Defaults to median
pitch estimated by \code{\link{analyze}}}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{play}{if TRUE, plays the processed audio}

\item{saveAudio}{full (!) path to folder for saving the processed audio; NULL
= don't save, '' = same as input folder (NB: overwrites the originals!)}
}
\description{
Internal soundgen function, see \code{\link{flatSpectrum}}.
}
\keyword{internal}
