% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchTrackers.R
\name{getPitchHps}
\alias{getPitchHps}
\title{Harmonic product spectrum}
\usage{
getPitchHps(
  frame,
  freqs,
  bin,
  hpsThres,
  hpsNum,
  hpsNorm,
  hpsPenalty,
  pitchFloor,
  pitchCeiling
)
}
\arguments{
\item{frame}{the abs spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{hpsThres}{voicing threshold (unitless, ~0 to 1)}

\item{hpsNum}{the number of times the spectrum is downsampled}

\item{hpsNorm}{the amount of inflation of hps pitch certainty (0 = none)}

\item{hpsPenalty}{the amount of penalizing hps candidates in low frequencies
(0 = none)}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}
}
\value{
Returns either NULL or a dataframe of pitch candidates.
}
\description{
Internal soundgen function.
}
\details{
Estimates pitch per frame using the harmonic product spectrum. Algorithm:
downsample the spectrum repeatedly padding with 0 to the original length,
then multiply the resulting scaled spectra. This has the effect of
emphasizing f0, which should hopefully become the highest spectral peak. See
https://cnx.org/contents/i5AAkZCP@2/Pitch-Detection-Algorithms
}
\keyword{internal}
