% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{osc_dB}
\alias{osc_dB}
\title{Oscillogram dB}
\usage{
osc_dB(x, dynamicRange = 80, maxAmpl = NULL, samplingRate = NULL,
  returnWave = FALSE, plot = TRUE, xlab = NULL, ylab = "dB",
  bty = "n", midline = TRUE, ...)
}
\arguments{
\item{x}{path to a .wav file or a CENTERED (mean ~= 0) vector of amplitudes
with specified samplingRate}

\item{dynamicRange}{dynamic range of the oscillogram, dB}

\item{maxAmpl}{the maximum theoretically possible value indicating on which
scale the sound is coded: 1 if the range is -1 to +1, 2^15 for 16-bit wav
files, etc}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than a .wav file)}

\item{returnWave}{if TRUE, returns a log-transformed waveform as a numeric vector}

\item{plot}{if TRUE, plots the oscillogram}

\item{xlab, ylab}{axis labels}

\item{bty}{box type (see `?par`)}

\item{midline}{if TRUE, draws a line at 0 dB}

\item{...}{Other graphical parameters passed on to `plot()`}
}
\value{
Returns the input waveform on a dB scale: a vector with
  range from `-dynamicRange` to `dynamicRange`.
}
\description{
Plots the oscillogram (waveform) of a sound on a logarithmic scale, in dB.
Analogous to "Waveform (dB)" view in Audacity.
}
\details{
Algorithm: centers and normalizes the sound, then takes a logarithm of the
positive part and a flipped negative part.
}
\examples{
sound = sin(1:2000/10) *
        getSmoothContour(anchors = c(1, .01, .5), len = 2000)

# Oscillogram on a linear scale
plot(sound, type = 'l')
# or, for fancy plotting options: seewave::oscillo(sound, f = 1000)

# Oscillogram on a dB scale
osc_dB(sound)

# Time in ms if samplingRate is specified
osc_dB(sound, samplingRate = 5000)

# Assuming that the waveform can range up to 50 instead of 1
osc_dB(sound, maxAmpl = 50)

# Embellish and customize the plot
o = osc_dB(sound, samplingRate = 1000, midline = FALSE,
           main = 'My waveform', col = 'blue')
abline(h = 0, col = 'orange', lty = 3)
}
