% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{getFormantDispersion}
\alias{getFormantDispersion}
\title{Get formant dispersion}
\usage{
getFormantDispersion(formants, speedSound = 35400, method = c("fast",
  "accurate")[2])
}
\arguments{
\item{formants}{a vector of formant frequencies, Hz}

\item{speedSound}{speed of sound in warm air, cm/s. Stevens (2000) "Acoustic
phonetics", p. 138}

\item{method}{method of calculating formant dispersion: \code{fast} for
simple averaging of inter-formant difference, \code{accurate} for fitting a
linear regression to formant frequencies}
}
\description{
Internal soundgen function.
}
\details{
Estimates formant dispersion based on one or more formant frequencies.
}
\examples{
nIter = 100  # nIter = 10000 for better results
speedSound = 35400
out = data.frame(vtl = runif(nIter, 5, 70),
                 nFormants = round(runif(nIter, 1, 10)),
                 noise = runif(nIter, 0, .2),
                 vtl_est = rep(NA, nIter),
                 error = rep(NA, nIter))
for (i in 1:nIter) {
  a = 1:out$nFormants[i]
  formants = sort(speedSound * (2 * a - 1) / (4 * out$vtl[i]) * rnorm(n = length(a),
                                                                 mean = 1,
                                                                 sd = out$noise[i]))
  disp = soundgen:::getFormantDispersion(formants, method = 'fast')
  out$vtl_est[i] = speedSound / 2 / disp
  out$error[i] = (out$vtl[i] -  out$vtl_est[i]) / out$vtl[i]
}
\dontrun{
library(ggplot2)
ggplot(out, aes(x = nFormants, y = error)) +
  geom_point(alpha = .1) +
  geom_smooth() +
  theme_bw()
ggplot(out, aes(x = noise, y = error)) +
  geom_point(alpha = .1) +
  geom_smooth() +
  theme_bw()
}
}
\keyword{internal}
