% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{divideIntoSyllables}
\alias{divideIntoSyllables}
\title{Syllable structure of a bout}
\usage{
divideIntoSyllables(nSyl, sylLen, pauseLen, sylDur_min = 20,
  sylDur_max = 10000, pauseDur_min = 20, pauseDur_max = 1000,
  temperature = 0.025, plot = FALSE)
}
\arguments{
\item{nSyl}{the desired number of syllables}

\item{sylLen}{the desired mean syllable duration, in ms}

\item{pauseLen}{the desired mean pause between syllables, in ms}

\item{sylDur_min, sylDur_max}{the lower and upper bounds on possible syllable
duration, in ms}

\item{pauseDur_min, pauseDur_max}{the lower and upper bounds on possible pause
duration, in ms}

\item{temperature}{a non-negative float regulating the stochasticity of
syllable segmentation; 0 = no stochasticity; 1 = sd of proposals is equal
to sylLen (very strong stochasticity)}

\item{plot}{produce a plot of syllable structure?}
}
\value{
Returns a matrix with a list of start-end points for syllables
}
\description{
Internal soundgen function.
}
\details{
Stochastic generation of syllable structure of a bout. Calls
\code{\link{rnorm_bounded}} to vary the duration of each new syllable and of
pauses between syllables. Total bout duration will also vary, unless
temperature is zero.
}
\examples{
soundgen:::divideIntoSyllables (nSyl = 5, sylLen = 180,
  pauseLen = 55, temperature = 0.2, plot = TRUE)
soundgen:::divideIntoSyllables (nSyl = 5, sylLen = 180,
  pauseLen = 55, temperature = 0)
soundgen:::divideIntoSyllables (nSyl = 3, sylLen = 100,
  pauseLen = 25, temperature = 0.5)
}
\keyword{internal}
