% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothContours.R
\name{reformatAnchors}
\alias{reformatAnchors}
\title{Reformat anchors}
\usage{
reformatAnchors(anchors, normalizeTime = TRUE)
}
\arguments{
\item{anchors}{a numeric vector of values or a list/dataframe with one column
(value) or two columns (time and value)}

\item{normalizeTime}{if TRUE, normalizes anchors$time values to range from 0 to 1}
}
\description{
Internal soundgen function.
}
\details{
Checks that the anchors are formatted in a valid way and expands them to a
standard dataframe with two columns: time and value. NB: works for all
anchors except noiseAnchors, which have to be scaled by sylLen and are
therefore processed directly in soundgen()
}
\examples{
soundgen:::reformatAnchors(150)
soundgen:::reformatAnchors(c(150, 200, 220))
soundgen:::reformatAnchors(anchors = list(value=c(150, 200, 220)))
soundgen:::reformatAnchors(anchors = list(time = c(0, 10, 100),
                                          value = c(150, 200, 220)))
# returns NA
soundgen:::reformatAnchors('aha')
# returns NA with a warning
soundgen:::reformatAnchors(anchors = list(time = c(0, .1, 1),
                                          freq = c(150, 200, 220)))
\dontrun{
# throws an error
soundgen:::reformatAnchors(anchors = list(time = c(0, .8, .7, 1),
                                          value = c(150, 200, 150, 220)))
}
}
\keyword{internal}
