% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{fadeInOut}
\alias{fadeInOut}
\title{Fade-in and fade-out}
\usage{
fadeInOut(ampl, do_fadeIn = TRUE, do_fadeOut = TRUE, length_fade = 1000)
}
\arguments{
\item{ampl}{numeric vector such as a waveform}

\item{do_fadeIn, do_fadeOut}{(logical) perform linear fade-in / fade-out?}

\item{length_fade}{the length of affected region, in points (expects an
integer > 1, otherwise just returns the original vector with no
modifications)}
}
\value{
Returns a numeric vector of the same length as input
}
\description{
Internal soundgen function.
}
\details{
Applies linear fade-in and fade-out of length 'length_fade' points to one or
both ends of input vector.
}
\examples{
ampl = sin(1:1000)
plot(soundgen:::fadeInOut(ampl, length_fade = 100), type = 'l')
plot(soundgen:::fadeInOut(ampl, length_fade = 300,
  do_fadeOut = FALSE), type = 'l')
# if the vector is shorter than twice the specified length_fade,
# fade-in/out regions overlap
plot(soundgen:::fadeInOut(ampl, length_fade = 700), type = 'l')
}
\keyword{internal}
