% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundchange.R
\name{soundchange}
\alias{soundchange}
\title{Constructor function for the \code{soundchange} class.}
\usage{
soundchange(x, name, transcription, desc = NULL, perl = F)
}
\arguments{
\item{x}{[character/function] Either a sound change, or a function that takes as arguments a character string named \code{x} and an object named \code{meta}, and returns a vector of character strings.}

\item{name}{[character] Name of the sound change. Length limit is not enforced, but it is recommended to not exceed 30 characters.}

\item{transcription}{[transcription] The \code{\link{transcription}} used in the notation of the sound change.}

\item{desc}{[character] A description of the change. May be as short or as long as needed. Defaults to \code{NULL}.}

\item{perl}{[logical] Use Perl-compatible regular expressions? This argument is only used when \code{x} is a character string. Defaults to \code{FALSE}.}
}
\value{
[soundchange] An object containing the provided data.
}
\description{
Either takes a sound change, translates it to a function, and wraps that into a \code{soundchange} object, or takes a function and wraps it into a \code{soundchange} object.
}
\details{
A \code{soundchange} object is basically a sound change function with some metadata: name, description, and associated transcription. The sound change function can be a simple substitution using \code{\link{gsub}}, or as complex as required. It must take two arguments: \code{x} which is a single character string to which the change is to be applied, and \code{meta} which can be any object that holds additional metadata; \code{meta} can also be \code{NULL}. The return value of a sound change function must be a vector of character strings. The ability to output multiple strings is primarily intended for reconstruction, and it is not recommended that it be used to fit multiple changes into a single function. Example: in language L, "*a" and "*e" merged to "a", and simultaneously *o, *u > o. Regardless of whether our functions depart from the current state and reconstruct proto-forms, or the opposite, two functions should be defined: one for the a-e merger, and one for the o-u merger. The difference between them will be that with a progressive change, each function will return only one value ("[ae] > a") whereas in a regressive one it will return two ("a > a, e").

When the sound change is given as a simple character string, rather than a complete function, the string must contain exactly one ">" or "<" sign. Spaces around it are ignored. The string may take full advantage of regular expressions, both the ones available in pure R, and custom ones defined by the user and accepted by \code{\link{expandMeta}}. Backreferences may be of particular usefulness. In short, any part of the 'find' string that is enclosed in brackets, is also available in the 'replace' string as \code{"\\\\1"}, \code{"\\\\2"}, etc. For example, if k's followed by e or i all change into s's, this process cannot be encoded as simply *\code{"k[ei] > s"} because this would result in the e/i being deleted. The correct notation would be \code{"k([ei]) > s\\\\1"}. However, see the caveat below.

 Warning! When the META column is missing from the transcription and generated automatically, the alternatives are listed using round- rather than square-bracket notation, i.e. as \code{"(x|y)"} rather than \code{"[xy]"}. This is necessary because some graphemes may be longer than one character, but a side effect of this is that when a user-defined metacharacter ("wild-card") is used in the 'find' part of the sound change string (the part before \code{"<"}), it adds a set of round brackets to that part of the string. In turn, this means that backreferences in the 'replace' part of the sound change string must either be shifted accordingly, or round brackets around metacharacters in the 'find' part omitted. For example, if intervocalic s is to be replaced with r, the sound change string should be \code{"VsV > \\\\1r\\\\2"} rather than *\code{"(V)s(V) > \\\\1r\\\\2"} because \code{"V"} itself is already translated to \code{"(a|ä|e|…"}.

Note that sound changes and their application do not require the data to be segmented and aligned. If sound changes are the only goal of the project, these two time-consuming steps can be safely omitted.
}
\section{Fields}{

\describe{
\item{\code{fun}}{[function] The sound change function.}

\item{\code{desc}}{[character] A description of the change. May be \code{NULL}.}

\item{\code{name}}{[character] The name of the change.}
}}

\examples{
# prepare sample transcription
trans <- loadSampleDataset ("trans-common")
# run soundchange
a2b <- soundchange ("a > b", "sample change", trans)
a2b <- soundchange ("b < a", "sample change", trans)
a2b <- soundchange (function(x,meta) gsub("a","b",x), "sample change", trans)
}
\seealso{
\code{\link{print.soundchange}}, \code{\link{applyChanges}}
}
