% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{long2wide}
\alias{long2wide}
\title{Convert from the long format (single entry per row) to the wide format (multiple entries per row).}
\usage{
long2wide(data, col.lang = "LANGUAGE", skip = NULL)
}
\arguments{
\item{data}{[data.frame] The dataset to be converted.}

\item{col.lang}{[character] Name of the column with language names. Defaults to \code{"LANGUAGE"}.}

\item{skip}{[character vector] Names of columns to not convert. Defaults to \code{NULL}.}
}
\value{
[data.frame] A data frame in the wide format (multiple entries per row).
}
\description{
Takes a data frame of word pairs/triples/..., each stored in multiple rows, and returns a data frame with the same words but each pair/triple/... stored in one row. WARNING: in the original data frame, entries from all languages must be in the same order.
}
\examples{
# path to sample data in the "long format"
fName <- system.file ("extdata", "data-abc.tsv", package="soundcorrs")
long <- read.table (fName, header=TRUE)
wide <- long2wide (long, skip=c("ID"))
}
