% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{wide2long}
\alias{wide2long}
\title{Convert from the wide format (multiple entries per row) to the long format (single entry per row).}
\usage{
wide2long(data, suffixes, col.lang = "LANGUAGE", strip = 0)
}
\arguments{
\item{data}{[data.frame] The dataset to be converted.}

\item{suffixes}{[character vector] Suffixes used to differentiate column names; in the output, those will be used as language names.}

\item{col.lang}{[character] Name of the column in which language names are to be stored. Defaults to \code{"LANGUAGE"}.}

\item{strip}{[integer] The number of characters to strip from the beginning of suffixes when they are turned into language names. Defaults to 0.}
}
\value{
[data.frame] A data frame in the long format (single entry per row).
}
\description{
Takes a data frame of word pairs/triples/..., each stored in a single row, and returns a data frame with the same pairs/triples/... but with each word stored in its own row.
}
\examples{
# path to sample data in the "wide format"
fName <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
wide <- read.table (fName, header=TRUE)
long <- wide2long (wide, c(".German",".Polish",".Spanish"), strip=1)
}
