% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{soundcorrs}
\alias{soundcorrs}
\title{Constructor function for the \code{soundcorrs} class.}
\usage{
soundcorrs(...)
}
\arguments{
\item{...}{[scOne] Multiple \code{\link{scOne}} objects to be combined.}
}
\value{
[soundcorrs] An object containing the data and metadata for multiple language.
}
\description{
Take multiple \code{\link{scOne}} objects and combine them into a single \code{soundcorrs} object.
}
\section{Fields}{

\describe{
\item{\code{cols}}{[character list] Names of important columns.}

\item{\code{data}}{[data.frame] The original data, merged.}

\item{\code{name}}{[character] Names of the languages.}

\item{\code{segms}}{[character list] Words exploded into segments. With linguistic zeros preserved (\code{$z}) or removed (\code{$nz}).}

\item{\code{segpos}}{[integer list] A lookup list to check which character belongs to which segment. Counted with linguistic zeros preserved (\code{$z}) and removed (\code{$nz}).}

\item{\code{separators}}{[character] Strings used as segment separators in \code{cols$aligned}.}

\item{\code{trans}}{[transcription] \code{\link{transcription}} objects.}

\item{\code{words}}{[character list] Words obtained by removing separators from the \code{cols$aligned} columns. With linguistic zeros (\code{$z}) or without them (\code{$nz}).}
}}

\examples{
# path to sample data in the "wide format"
fNameData <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
# path to a sample transcription
fNameTrans <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
ger <- read.scOne (fNameData, "German", "ALIGNED.German", fNameTrans)
pol <- read.scOne (fNameData, "Polish", "ALIGNED.Polish", fNameTrans)
spa <- read.scOne (fNameData, "Spanish", "ALIGNED.Spanish", fNameTrans)
dataset <- soundcorrs (ger, pol, spa)
}
