% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{binTable}
\alias{binTable}
\title{Sum all rows and all columns in a table, except for the selected ones.}
\usage{
binTable(x, row, col)
}
\arguments{
\item{x}{[data.frame/matrix/table] Table to be binned.}

\item{row}{[integer/vector] The rows to not be binned.}

\item{col}{[integer/vector] The columns to not be binned.}
}
\value{
[table] Table with some of its data binned.
}
\description{
Useful for when the data are scarce and \code{\link{chisq.test}} returns a warning, or when a more specific analysis of the data is required.
}
\examples{
mtx <- matrix (1:16, nrow=4, dimnames=list(paste0("r",1:4),paste0("c",1:4)))
binTable (mtx, 1, 1)
binTable (mtx, 1, c(1,3))
}
