\name{PackageSum2}
\alias{PackageSum2}
\alias{PackageSum2.findFn}
\alias{PackageSum2.data.frame}
\alias{PackageSum2.list}
\title{
  Add Info from Installed Packages to PackageSummary
}
\description{
  Add information on installed packages to the \code{PackageSummary} of
  a \code{findFn} object.
}
\usage{
PackageSum2(x,
        fields=c("Title", "Version", "Author", "Maintainer", "Packaged",
                 'helpPages', 'vignette'), lib.loc=NULL, ...)
\method{PackageSum2}{findFn}(x,
        fields=c("Title", "Version", "Author", "Maintainer", "Packaged",
                 'helpPages', 'vignette'), lib.loc=NULL, ...)
\method{PackageSum2}{data.frame}(x,
        fields=c("Title", "Version", "Author", "Maintainer", "Packaged",
                 'helpPages', 'vignette'), lib.loc=NULL, ...)
\method{PackageSum2}{list}(x,
        fields=c("Title", "Version", "Author", "Maintainer", "Packaged",
                 'helpPages', 'vignette'), lib.loc=NULL, ...)
}
\arguments{
  \item{x}{
    a data.frame with columns \code{Package} and \code{Score}.
  }
  \item{fields}{
    character vector of names of columns to add to \code{x}.  The
    function first looks  in the components of
    \code{packageDescription(x$Package[i])}.  'vignette' is obtained via
    the function of that name.

    Component 'Packaged' receives special treatment.  If present, only
    the portion preceding ';' will be retained.  This seems to be a time
    stamp automatically generated by something like \code{R CMD build}.
    It is absent for packages automatically loaded when R is started.
    In such cases, the third component of \code{strsplit(
    packageDescription( x$Package[i])$Built, ..., ';')} will be stored
    as 'Packaged'.  This seems to be a time stamp automatically
    generated by something like \code{R CMD INSTALL --build}.
  }
  \item{lib.loc}{
    an optional \code{lib.loc} argument passed to
    \code{packageDescription}.
  }
  \item{\dots}{
    additional arguments (currently unused)
  }
}
\details{
  With an object of class \code{findFn}, extract the
  \code{PackageSummary} attribute and pass it to the \code{data.frame}
  method.

  With an object of class \code{list}, extract the \code{PackageSummary}
  component and pass it to the \code{data.frame} method.

  For a \code{data.frame} that is not an \code{findFn} object, add
  other columns from \code{attributes} of \code{packageDescription} for
  installed packages named in the column \code{Package}.
}
\value{
  a data.frame with additional \code{fields} columns appended to a
  package summary data.frame.
}
\author{Spencer Graves}
\seealso{
  \code{\link{findFn}}
  \code{\link{PackageSummary}}
}
\examples{
##
## data.frame method
##
tstdf <- data.frame(Package=c('grid', 'base'), stringsAsFactors=FALSE)
tst2 <- PackageSum2(tstdf)

##
## list method
##
tstList <- list(PackageSummary=tstdf)
\dontshow{stopifnot(}
all.equal(tst2, PackageSum2(tstList))
\dontshow{)}

##
## findFn method
##
tst.findFn <- data.frame(Package=c('grid', 'base')[c(1,1,2)], Score=2:4,
                    Date=LETTERS[1:3], stringsAsFactors=FALSE)
attr(tst.findFn, 'PackageSummary') <- PackageSummary(tst.findFn)
class(tst.findFn) <- c('findFn', 'data.frame')
tst2. <- PackageSum2(tst.findFn)

# row names are different from tst2, so fix ...
row.names(tst2.) <- row.names(tst2)
\dontshow{stopifnot(}
all.equal(tst2, tst2.[names(tst2)])
\dontshow{)}

}
\keyword{package}
