% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{naturalFrequency}
\alias{naturalFrequency}
\title{Calculate the natural frequency}
\usage{
naturalFrequency(L, C = "default", R)
}
\arguments{
\item{L}{Inductance}

\item{C}{Capacitance, by default IUPAC standard pressure.}

\item{R}{Resistance}
}
\description{
Calculates the natural frequency given the inductance, capacitance and resistance. In the acoustic case
the inductance is inertia or mass, the capacitance is elasticity (bulk modulus) and resistance is composed of air
resistance and related quantities. All units are SI.
}
\details{
For isothermal compression, the bulk modulus is equal to the pressure. The default value of C therefore is the IUPAC
standard pressure.
}
\examples{
naturalFrequency(L=20,R=0.5)
naturalFrequency(L=20,C=1/4,R=0.5)
}
